#!/bin/sh
. ./dply_page_sb_image_path_select_no_image.sh
. ./dply_page_sb_image_path_select_too_many_image.sh

DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK=0
DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR=1
DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=${DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR}
DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""

dply_page_sb_image_path_select() {
	debug_print "in function '${FUNCNAME[0]}'"
    
    local text=`printf \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_TEXT}" \
            "3"`
    
    # DTAS-01206: [Deployment] [US PM] Revise error message when the prefix of sandbox image is wrong
    # check if there is any available sandbox image first
    utility_get_esxi_all_vmx_files \
        "${RT_ESXI_IP:-$conf_esxi_ip}" \
        "${RT_ESXI_USERNAME:-$conf_esxi_username}" \
        "${RT_ESXI_PASSWORD:-$conf_esxi_password}" \
        "${conf_sb_prefix}" \
        "available"
    if [ -z "${UTILITY_GET_ESXI_ALL_VMX_FILES_MSG}" ]; then
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE="${DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR}"
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG="${ERROR_ESXI_CANNOT_GET_IMAGE_PATH_SB}"
        return
    fi
    debug_print "vmx files: ${UTILITY_GET_ESXI_ALL_VMX_FILES_MSG}"

    tp_esxi_image_select_checklist \
        "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_TITLE}" \
        "${text}" \
        "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_LABEL_OK}" \
        "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_LABEL_CANCEL}" \
        "${RT_ESXI_IP:-$conf_esxi_ip}" \
        "${RT_ESXI_USERNAME:-$conf_esxi_username}" \
        "${RT_ESXI_PASSWORD:-$conf_esxi_password}" \
        "${conf_sb_prefix}" \
        "available" \
        "${RT_SB_NUMBER}"
    
    debug_print "TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE: ${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE}"
    case "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE}" in
    
        "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_ERROR}" )
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
			if [ "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG}" == "${TP_ESXI_IMAGE_SELECT_ERROR_DATASTORE_IS_NOT_FOUND}" ]; then
				DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=$ERROR_ESXI_CANNOT_GET_IMAGE_PATH_DATASTORE
			else
				DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=$ERROR_ESXI_CANNOT_GET_IMAGE_PATH_SB
			fi
            return
            ;;
            
        "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CANCEL}" )
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            ;;
            
        "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CTRLC}" )
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            ;;
        
        "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_OK}" )
            ;;
            
        * )
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG="${DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_UNKNOWN}"
            return
            ;;
    esac

    
    # no image is selected
    if [ -z "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH}" ]; then
        debug_print "SelectNoImage: img='${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH}'"
        
        tp_msg_ok \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_TITLE}" \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_NO_IMAGES}" \
            "${STRING_OK}"
        
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
        return
    fi
    
    
    # too many images are selected
    local selected_images="`echo "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH}" | awk -F ".vmx" '{print NF-1}'`"
    if [ "${selected_images}" -gt 3 ]; then
        debug_print "SelectTooManyImages: img='${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH}'"
        
        local text=""
        text=`printf \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_TOO_MANY_IMAGES}" \
            "3"`

        tp_msg_ok \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_TITLE}" \
            "${text}" \
            "${STRING_OK}"

        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
        return
    fi
    
    
    # selected images are greater than sandbox total number
    # ex. user might specify sandbox total number as '1'
    if [ "${selected_images}" -gt $RT_SB_NUMBER ]; then
        debug_print "SelectedImagesGreaterThanSandboxTotalNumber: img='${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH}', count='${selected_images}', RT_SB_NUMBER='${RT_SB_NUMBER}'"
        
        local text=`printf \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_TOO_MANY_IMAGES}" \
            "${RT_SB_NUMBER}"`

        tp_msg_ok \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_TITLE}" \
            "${text}" \
            "${STRING_OK}"

        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
        return
    fi
    
    
    # multiple check: 'SandboxTotalNumber' must be multiple of 'SelectedSandboxNumber'
	local is_multiple=`expr $RT_SB_NUMBER % $selected_images`
	if [ $is_multiple -ne 0 ]; then
    
		local text=`printf \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_NOT_MULTIPLES}" \
            "${RT_SB_NUMBER}" \
            "${selected_images}"`
        
        tp_msg_ok \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_TITLE}" \
            "${text}" \
            "${STRING_OK}"

        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
        return
    fi
    
    # check if selected images is powered off
    local poweron_img_list
    local msg
    local ret
    local img
    for img in `echo $TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH | sed 's/,/ /g'`
    do
        debug_print "CheckSelectedImagesPowerStatus: img='${img}'"
        
        msg=`php $CONS_BACKEND get_esxi_vm_state "${RT_ESXI_IP}" "${RT_ESXI_USERNAME}" "${RT_ESXI_PASSWORD}" "${img}"`
        ret="${?}"
        
        if [ "${ret}" -ne 0 ]; then
            local errMsg="CallBackendFunctionsFail: name='get_esxi_vm_state', msg='${msg}'"
            debug_print "${errMsg}"
            
            tp_msg_ok \
                "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_TITLE}" \
                "${errMsg}" \
                "${STRING_OK}"
                
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            
        elif [ "${msg}" = "getstate() = on" ]; then
            
            # translate to short version
            local tmp
            tmp=`dirname "${img}"`
            tmp=`basename "${tmp}"`
            
            [ -z "${poweron_img_list}" ] \
                && poweron_img_list="${tmp}"  \
                || poweron_img_list="${poweron_img_list}, ${tmp}"
        fi
    done
    
    if [ ! -z "${poweron_img_list}" ]; then 
        debug_print "CheckSelectedImagesPowerStatusFail: img='${poweron_img_list}'"
        
        tp_msg_ok \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_TITLE}" \
            "${DPLY_PAGE_SB_IMAGE_PATH_SELECT_ERROR_POWEROFF_IMAGE}: ${poweron_img_list}" \
            "${STRING_OK}"

        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
        DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
        return
    fi
    debug_print "CheckSelectedImagesPowerStatusPass"

    # utility_save_multi_sb_image_path_conf \
        # "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH}" \
        # "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX}"

    # save to runtime variables
    RT_SB_IMAGE_PATH="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT}"
    RT_SB_IMAGE_PATH_ESXI="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH}"
    RT_SB_IMAGE_PATH_VIX="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX}"
    debug_print "RT_SB_IMAGE_PATH: ${RT_SB_IMAGE_PATH}"
    debug_print "RT_SB_IMAGE_PATH_ESXI: ${RT_SB_IMAGE_PATH_ESXI}"
    debug_print "RT_SB_IMAGE_PATH_VIX: ${RT_SB_IMAGE_PATH_VIX}"
    
    DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
    DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=1
    DPLY_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
}
